using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using gov.va.med.vbecs.Common;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for PatientSpecimenSelector.
	/// </summary>
	public class PatientOrderSelector : GUI.controls.BaseControl 
	{
		#region Variables
		private BOL.Specimen _specimen;
		//private string _divisionCode;
		//
		private System.EventHandler onSIAndTRClick;
		private System.EventHandler onBloodAvailClick;
		private System.EventHandler onVbecsInfoClick;
		private System.EventHandler onMedicationsClick;
		private System.EventHandler onTransHistoryClick;
		private System.EventHandler onClinicalInfoClick;
		
		/// <summary>
		/// ItemSelected
		/// </summary>
		public event EventHandler ItemSelected;

		/// <summary>
		/// ItemDeselected 
		/// </summary>
		public event EventHandler ItemDeselected;
		
		private DataTable _dtSpecimenSearchDetails;
		private int _recordsFoundColSize;
		private int _noRecordsFoundColSize;
		private Guid _patientSpecimenGUID;
		private Guid _patientOrderGUID;		
		private Guid _orderedTestGuid;
		private Guid _orderedComponentGuid;
		private Guid _patientTreatmentGuid;
		private int	_orderableTestID;
		private Common.OrderStatus _orderStatusCode;
		private bool _unexpiredOnlySpecimen = true;
		private BOL.Patient _patient;

		private Regex _lastfiveEx;
		private Regex _ssnEx;
		private Regex _nameEx;
		#endregion

		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label lblPatientName;
		private System.Windows.Forms.TextBox txtSSN;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.TextBox txtABORh;
		private System.Windows.Forms.TextBox txtSex;
		private System.Windows.Forms.Label lblDOB;
		private System.Windows.Forms.TextBox txtDOB;
		private System.Windows.Forms.Label lblSSN;
		private System.Windows.Forms.Label lblSex;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.Label lblPhlebotomist;
		private System.Windows.Forms.TextBox txtPhlebotomist;
		private System.Windows.Forms.Label lblCollectionDate;
		private System.Windows.Forms.GroupBox grpSearchResults;
		private System.Windows.Forms.ListView lvSearchResults;
		private System.Windows.Forms.ColumnHeader colPatientName;
		private System.Windows.Forms.ColumnHeader colSSN;
		private System.Windows.Forms.ColumnHeader colVBECSSpecimen;
		private System.Windows.Forms.GroupBox grpSearchCriteria;
		private System.Windows.Forms.Label lblSearchOrderNumber;
		private System.Windows.Forms.Label lblSearchNameSSN;
		private System.Windows.Forms.TextBox txtSearchNameSSN;
		private System.Windows.Forms.GroupBox grpSelectedSpecimen;
		private System.Windows.Forms.TabControl tabPatientOrder;
		private System.Windows.Forms.TabPage pagePatient;
		private System.Windows.Forms.TabPage pageOrder;
		private System.Windows.Forms.TextBox txtCollectionDate;
		private System.Windows.Forms.TextBox txtSpecimenNumber;
		private System.Windows.Forms.Label lblSpecimenNumber;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.TextBox txtOrderDate;
		private System.Windows.Forms.Label lblOrderDate;
		private System.Windows.Forms.TextBox txtOrderedBy;
		private System.Windows.Forms.Label lblOrderedBy;
		private System.Windows.Forms.TextBox txtOrderComments;
		private System.Windows.Forms.Label lblOrderComments;
		private System.Windows.Forms.TextBox txtRequestedProcedure;
		private System.Windows.Forms.Label lblRequestedProcedure;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.HelpProvider helpProvider1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.TextBox txtOrderStatus;
		private System.Windows.Forms.Label lblOrderStatus;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtSearchOrderNumber;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar patientInfoToolbar1;
		private System.Windows.Forms.TextBox txtCPRSOrderNumber;
		private System.Windows.Forms.Label lblCPRSOrderNumber;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSearch;
		private System.Windows.Forms.ColumnHeader colAssociatedTest;
		private System.Windows.Forms.CheckBox cbShowExpiredUnacceptable;
		private System.Windows.Forms.TextBox txtVisualInspection;
		private System.Windows.Forms.Label lblVisualInspection;
		private System.Windows.Forms.PictureBox picJustified;
		private System.ComponentModel.IContainer components;
		#endregion

		#region Constructors\Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public PatientOrderSelector()
		{
			InitializeComponent();
			SetComponentProperties();
			this._recordsFoundColSize = this.lvSearchResults.Columns[0].Width;
			this._noRecordsFoundColSize = this.lvSearchResults.Columns[0].Width + 50;
			//
			_lastfiveEx =  Common.RegularExpressions.PatientInitialAndLastFourSSN();
			_ssnEx = Common.RegularExpressions.PatientSsn();
			_nameEx =  Common.RegularExpressions.PatientName();
			//
			_patient = null;
		}

		/// <summary>
		/// Constructor that accepts Patient BOL, so we can default search boxes
		/// </summary>
		/// <param name="patient"></param>
		public PatientOrderSelector(BOL.Patient patient)
		{
			InitializeComponent();
			SetComponentProperties();
			this._recordsFoundColSize = this.lvSearchResults.Columns[0].Width;
			this._noRecordsFoundColSize = this.lvSearchResults.Columns[0].Width + 50;
			//
			_lastfiveEx =  Common.RegularExpressions.PatientInitialAndLastFourSSN();
			_ssnEx = Common.RegularExpressions.PatientSsn();
			_nameEx =  Common.RegularExpressions.PatientName();
			//
			if (patient.LastName.Length > 0)
			{
				this.txtSearchNameSSN.Text = patient.LastName.ToString();
				this.txtSearchNameSSN.ReadOnly = true;
				this.btnSearch.Enabled = true;
				this._patient = patient;
			}
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		/// <param name="specimenUId"></param>
		public PatientOrderSelector(BOL.Patient patient, string specimenUId)
		{
			InitializeComponent();
			SetComponentProperties();
			this._recordsFoundColSize = this.lvSearchResults.Columns[0].Width;
			this._noRecordsFoundColSize = this.lvSearchResults.Columns[0].Width + 50;
			//
			_lastfiveEx =  Common.RegularExpressions.PatientInitialAndLastFourSSN();
			_ssnEx = Common.RegularExpressions.PatientSsn();
			_nameEx =  Common.RegularExpressions.PatientName();
			//
			if (patient.LastName.Length > 0)
			{
				this.txtSearchNameSSN.Text = patient.LastName.ToString();
				this.txtSearchNameSSN.ReadOnly = true;
				this.btnSearch.Enabled = true;
				this._patient = patient;
			}
			//
			this.txtSearchOrderNumber.Text = specimenUId;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion
        
		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PatientOrderSelector));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpSearchCriteria = new System.Windows.Forms.GroupBox();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.txtSearchOrderNumber = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
			this.txtSearchNameSSN = new System.Windows.Forms.TextBox();
			this.lblSearchOrderNumber = new System.Windows.Forms.Label();
			this.lblSearchNameSSN = new System.Windows.Forms.Label();
			this.grpSelectedSpecimen = new System.Windows.Forms.GroupBox();
			this.txtVisualInspection = new System.Windows.Forms.TextBox();
			this.lblVisualInspection = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.tabPatientOrder = new System.Windows.Forms.TabControl();
			this.pagePatient = new System.Windows.Forms.TabPage();
			this.picJustified = new System.Windows.Forms.PictureBox();
			this.patientInfoToolbar1 = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.lblPatientName = new System.Windows.Forms.Label();
			this.txtSSN = new System.Windows.Forms.TextBox();
			this.lblABORh = new System.Windows.Forms.Label();
			this.txtABORh = new System.Windows.Forms.TextBox();
			this.txtSex = new System.Windows.Forms.TextBox();
			this.lblDOB = new System.Windows.Forms.Label();
			this.txtDOB = new System.Windows.Forms.TextBox();
			this.lblSSN = new System.Windows.Forms.Label();
			this.lblSex = new System.Windows.Forms.Label();
			this.txtPatientName = new System.Windows.Forms.TextBox();
			this.pageOrder = new System.Windows.Forms.TabPage();
			this.txtOrderStatus = new System.Windows.Forms.TextBox();
			this.lblOrderStatus = new System.Windows.Forms.Label();
			this.txtOrderDate = new System.Windows.Forms.TextBox();
			this.lblOrderDate = new System.Windows.Forms.Label();
			this.txtOrderedBy = new System.Windows.Forms.TextBox();
			this.lblOrderedBy = new System.Windows.Forms.Label();
			this.txtOrderComments = new System.Windows.Forms.TextBox();
			this.lblOrderComments = new System.Windows.Forms.Label();
			this.txtRequestedProcedure = new System.Windows.Forms.TextBox();
			this.lblRequestedProcedure = new System.Windows.Forms.Label();
			this.txtCPRSOrderNumber = new System.Windows.Forms.TextBox();
			this.lblCPRSOrderNumber = new System.Windows.Forms.Label();
			this.txtCollectionDate = new System.Windows.Forms.TextBox();
			this.txtSpecimenNumber = new System.Windows.Forms.TextBox();
			this.lblSpecimenNumber = new System.Windows.Forms.Label();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.lblPhlebotomist = new System.Windows.Forms.Label();
			this.txtPhlebotomist = new System.Windows.Forms.TextBox();
			this.lblCollectionDate = new System.Windows.Forms.Label();
			this.grpSearchResults = new System.Windows.Forms.GroupBox();
			this.cbShowExpiredUnacceptable = new System.Windows.Forms.CheckBox();
			this.lvSearchResults = new System.Windows.Forms.ListView();
			this.colVBECSSpecimen = new System.Windows.Forms.ColumnHeader();
			this.colPatientName = new System.Windows.Forms.ColumnHeader();
			this.colSSN = new System.Windows.Forms.ColumnHeader();
			this.colAssociatedTest = new System.Windows.Forms.ColumnHeader();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.helpProvider1 = new System.Windows.Forms.HelpProvider();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.grpImage.SuspendLayout();
			this.grpSearchCriteria.SuspendLayout();
			this.grpSelectedSpecimen.SuspendLayout();
			this.tabPatientOrder.SuspendLayout();
			this.pagePatient.SuspendLayout();
			this.pageOrder.SuspendLayout();
			this.grpSearchResults.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 400);
			this.grpImage.TabIndex = 3;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpSearchCriteria
			// 
			this.grpSearchCriteria.AccessibleDescription = "Specimen Search Criteria";
			this.grpSearchCriteria.AccessibleName = "Specimen Search Criteria";
			this.grpSearchCriteria.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchCriteria.Controls.Add(this.btnSearch);
			this.grpSearchCriteria.Controls.Add(this.pictureBox2);
			this.grpSearchCriteria.Controls.Add(this.txtSearchOrderNumber);
			this.grpSearchCriteria.Controls.Add(this.txtSearchNameSSN);
			this.grpSearchCriteria.Controls.Add(this.lblSearchOrderNumber);
			this.grpSearchCriteria.Controls.Add(this.lblSearchNameSSN);
			this.grpSearchCriteria.Location = new System.Drawing.Point(56, 0);
			this.grpSearchCriteria.Name = "grpSearchCriteria";
			this.grpSearchCriteria.Size = new System.Drawing.Size(320, 72);
			this.grpSearchCriteria.TabIndex = 0;
			this.grpSearchCriteria.TabStop = false;
			this.grpSearchCriteria.Text = "Specimen Search Criteria*";
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.EnabledButton = false;
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(236, 44);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 3;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			this.btnSearch.MouseHover += new System.EventHandler(this.btnSearch_MouseHover);
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 48);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(20, 20);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 113;
			this.pictureBox2.TabStop = false;
			// 
			// txtSearchOrderNumber
			// 
			this.txtSearchOrderNumber.AccessibleDescription = "Specimen U I D ";
			this.txtSearchOrderNumber.AccessibleName = "Specimen U I D";
			this.txtSearchOrderNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSearchOrderNumber.Barcode = false;
			this.txtSearchOrderNumber.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtSearchOrderNumber.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtSearchOrderNumber.Location = new System.Drawing.Point(96, 44);
			this.txtSearchOrderNumber.MaxLength = 15;
			this.txtSearchOrderNumber.Name = "txtSearchOrderNumber";
			this.txtSearchOrderNumber.Size = new System.Drawing.Size(136, 20);
			this.txtSearchOrderNumber.TabIndex = 2;
			this.txtSearchOrderNumber.Text = "";
			this.txtSearchOrderNumber.TextChanged += new System.EventHandler(this.SearchCriteriaChanged);
			// 
			// txtSearchNameSSN
			// 
			this.txtSearchNameSSN.AccessibleDescription = "Patient";
			this.txtSearchNameSSN.AccessibleName = "Patient";
			this.txtSearchNameSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSearchNameSSN.Location = new System.Drawing.Point(96, 20);
			this.txtSearchNameSSN.MaxLength = 20;
			this.txtSearchNameSSN.Name = "txtSearchNameSSN";
			this.txtSearchNameSSN.Size = new System.Drawing.Size(216, 20);
			this.txtSearchNameSSN.TabIndex = 1;
			this.txtSearchNameSSN.Text = "";
			this.txtSearchNameSSN.TextChanged += new System.EventHandler(this.SearchCriteriaChanged);
			// 
			// lblSearchOrderNumber
			// 
			this.lblSearchOrderNumber.Location = new System.Drawing.Point(24, 44);
			this.lblSearchOrderNumber.Name = "lblSearchOrderNumber";
			this.lblSearchOrderNumber.Size = new System.Drawing.Size(80, 20);
			this.lblSearchOrderNumber.TabIndex = 2;
			this.lblSearchOrderNumber.Text = "Specimen UID";
			this.lblSearchOrderNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSearchNameSSN
			// 
			this.lblSearchNameSSN.Location = new System.Drawing.Point(24, 20);
			this.lblSearchNameSSN.Name = "lblSearchNameSSN";
			this.lblSearchNameSSN.Size = new System.Drawing.Size(76, 20);
			this.lblSearchNameSSN.TabIndex = 0;
			this.lblSearchNameSSN.Text = "Patient ";
			this.lblSearchNameSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSelectedSpecimen
			// 
			this.grpSelectedSpecimen.AccessibleDescription = "Selected Patient Specimen";
			this.grpSelectedSpecimen.AccessibleName = "Selected Patient Specimen";
			this.grpSelectedSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelectedSpecimen.Controls.Add(this.txtVisualInspection);
			this.grpSelectedSpecimen.Controls.Add(this.lblVisualInspection);
			this.grpSelectedSpecimen.Controls.Add(this.txtExpirationDate);
			this.grpSelectedSpecimen.Controls.Add(this.tabPatientOrder);
			this.grpSelectedSpecimen.Controls.Add(this.txtCollectionDate);
			this.grpSelectedSpecimen.Controls.Add(this.txtSpecimenNumber);
			this.grpSelectedSpecimen.Controls.Add(this.lblSpecimenNumber);
			this.grpSelectedSpecimen.Controls.Add(this.lblExpirationDate);
			this.grpSelectedSpecimen.Controls.Add(this.lblPhlebotomist);
			this.grpSelectedSpecimen.Controls.Add(this.txtPhlebotomist);
			this.grpSelectedSpecimen.Controls.Add(this.lblCollectionDate);
			this.grpSelectedSpecimen.Location = new System.Drawing.Point(380, 0);
			this.grpSelectedSpecimen.Name = "grpSelectedSpecimen";
			this.grpSelectedSpecimen.Size = new System.Drawing.Size(308, 400);
			this.grpSelectedSpecimen.TabIndex = 7;
			this.grpSelectedSpecimen.TabStop = false;
			this.grpSelectedSpecimen.Text = "Selected Patient Specimen";
			// 
			// txtVisualInspection
			// 
			this.txtVisualInspection.AccessibleDescription = "Visual Inspection";
			this.txtVisualInspection.AccessibleName = "Visual Inspection";
			this.txtVisualInspection.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtVisualInspection.Location = new System.Drawing.Point(116, 116);
			this.txtVisualInspection.Name = "txtVisualInspection";
			this.txtVisualInspection.ReadOnly = true;
			this.txtVisualInspection.Size = new System.Drawing.Size(180, 20);
			this.txtVisualInspection.TabIndex = 12;
			this.txtVisualInspection.Text = "";
			// 
			// lblVisualInspection
			// 
			this.lblVisualInspection.Location = new System.Drawing.Point(8, 116);
			this.lblVisualInspection.Name = "lblVisualInspection";
			this.lblVisualInspection.Size = new System.Drawing.Size(96, 20);
			this.lblVisualInspection.TabIndex = 8;
			this.lblVisualInspection.Text = "Visual Inspection";
			this.lblVisualInspection.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtExpirationDate.AccessibleName = "Expiration Date";
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(116, 92);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(180, 20);
			this.txtExpirationDate.TabIndex = 11;
			this.txtExpirationDate.Text = "";
			// 
			// tabPatientOrder
			// 
			this.tabPatientOrder.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabPatientOrder.Controls.Add(this.pagePatient);
			this.tabPatientOrder.Controls.Add(this.pageOrder);
			this.tabPatientOrder.Location = new System.Drawing.Point(4, 152);
			this.tabPatientOrder.Name = "tabPatientOrder";
			this.tabPatientOrder.SelectedIndex = 0;
			this.tabPatientOrder.Size = new System.Drawing.Size(300, 240);
			this.tabPatientOrder.TabIndex = 13;
			// 
			// pagePatient
			// 
			this.pagePatient.Controls.Add(this.picJustified);
			this.pagePatient.Controls.Add(this.patientInfoToolbar1);
			this.pagePatient.Controls.Add(this.lblPatientName);
			this.pagePatient.Controls.Add(this.txtSSN);
			this.pagePatient.Controls.Add(this.lblABORh);
			this.pagePatient.Controls.Add(this.txtABORh);
			this.pagePatient.Controls.Add(this.txtSex);
			this.pagePatient.Controls.Add(this.lblDOB);
			this.pagePatient.Controls.Add(this.txtDOB);
			this.pagePatient.Controls.Add(this.lblSSN);
			this.pagePatient.Controls.Add(this.lblSex);
			this.pagePatient.Controls.Add(this.txtPatientName);
			this.pagePatient.Location = new System.Drawing.Point(4, 23);
			this.pagePatient.Name = "pagePatient";
			this.pagePatient.Size = new System.Drawing.Size(292, 213);
			this.pagePatient.TabIndex = 0;
			this.pagePatient.Text = "Patient Details";
			// 
			// picJustified
			// 
			this.picJustified.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picJustified.Image = ((System.Drawing.Image)(resources.GetObject("picJustified.Image")));
			this.picJustified.Location = new System.Drawing.Point(270, 126);
			this.picJustified.Name = "picJustified";
			this.picJustified.Size = new System.Drawing.Size(16, 16);
			this.picJustified.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picJustified.TabIndex = 75;
			this.picJustified.TabStop = false;
			this.toolTip1.SetToolTip(this.picJustified, "The patient has a history of  justified ABO/Rh change");
			this.picJustified.Visible = false;
			// 
			// patientInfoToolbar1
			// 
			this.patientInfoToolbar1.AccessibleDescription = "Patient Information Toolbar";
			this.patientInfoToolbar1.AccessibleName = "Patient Information Toolbar";
			this.patientInfoToolbar1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.patientInfoToolbar1.EnabledBloodAvailButton = false;
			this.patientInfoToolbar1.EnabledMedicationButton = false;
			this.patientInfoToolbar1.EnabledRecentOrdersButton = false;
			this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientInfoToolbar1.EnabledSIAndTRButton = false;
			this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = false;
			this.patientInfoToolbar1.Location = new System.Drawing.Point(134, 188);
			this.patientInfoToolbar1.Name = "patientInfoToolbar1";
			this.patientInfoToolbar1.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientInfoToolbar1.Patient = null;
			this.patientInfoToolbar1.Size = new System.Drawing.Size(154, 20);
			this.patientInfoToolbar1.TabIndex = 19;
			// 
			// lblPatientName
			// 
			this.lblPatientName.Location = new System.Drawing.Point(4, 4);
			this.lblPatientName.Name = "lblPatientName";
			this.lblPatientName.Size = new System.Drawing.Size(84, 20);
			this.lblPatientName.TabIndex = 0;
			this.lblPatientName.Text = "Patient Name";
			this.lblPatientName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSSN
			// 
			this.txtSSN.AccessibleDescription = "Patient I D";
			this.txtSSN.AccessibleName = "Patient I D";
			this.txtSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSSN.Location = new System.Drawing.Point(108, 28);
			this.txtSSN.Name = "txtSSN";
			this.txtSSN.ReadOnly = true;
			this.txtSSN.Size = new System.Drawing.Size(180, 20);
			this.txtSSN.TabIndex = 15;
			this.txtSSN.Text = "";
			// 
			// lblABORh
			// 
			this.lblABORh.Location = new System.Drawing.Point(4, 124);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(68, 20);
			this.lblABORh.TabIndex = 8;
			this.lblABORh.Text = "ABO/Rh";
			this.lblABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtABORh
			// 
			this.txtABORh.AccessibleDescription = "A B O R h";
			this.txtABORh.AccessibleName = "A B O R h";
			this.txtABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtABORh.Location = new System.Drawing.Point(108, 124);
			this.txtABORh.Name = "txtABORh";
			this.txtABORh.ReadOnly = true;
			this.txtABORh.Size = new System.Drawing.Size(180, 20);
			this.txtABORh.TabIndex = 18;
			this.txtABORh.Text = "";
			// 
			// txtSex
			// 
			this.txtSex.AccessibleDescription = "Patient Sex";
			this.txtSex.AccessibleName = "Patient Sex";
			this.txtSex.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSex.Location = new System.Drawing.Point(108, 52);
			this.txtSex.Name = "txtSex";
			this.txtSex.ReadOnly = true;
			this.txtSex.Size = new System.Drawing.Size(180, 20);
			this.txtSex.TabIndex = 15;
			this.txtSex.Text = "";
			// 
			// lblDOB
			// 
			this.lblDOB.Location = new System.Drawing.Point(4, 76);
			this.lblDOB.Name = "lblDOB";
			this.lblDOB.Size = new System.Drawing.Size(72, 20);
			this.lblDOB.TabIndex = 6;
			this.lblDOB.Text = "Date of Birth";
			this.lblDOB.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDOB
			// 
			this.txtDOB.AccessibleDescription = "Date Of Birth";
			this.txtDOB.AccessibleName = "Date Of Birth";
			this.txtDOB.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDOB.Location = new System.Drawing.Point(108, 76);
			this.txtDOB.Name = "txtDOB";
			this.txtDOB.ReadOnly = true;
			this.txtDOB.Size = new System.Drawing.Size(180, 20);
			this.txtDOB.TabIndex = 17;
			this.txtDOB.Text = "";
			// 
			// lblSSN
			// 
			this.lblSSN.Location = new System.Drawing.Point(4, 28);
			this.lblSSN.Name = "lblSSN";
			this.lblSSN.Size = new System.Drawing.Size(84, 20);
			this.lblSSN.TabIndex = 2;
			this.lblSSN.Text = "Patient ID";
			this.lblSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSex
			// 
			this.lblSex.Location = new System.Drawing.Point(4, 52);
			this.lblSex.Name = "lblSex";
			this.lblSex.Size = new System.Drawing.Size(84, 20);
			this.lblSex.TabIndex = 4;
			this.lblSex.Text = "Patient Sex";
			this.lblSex.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPatientName
			// 
			this.txtPatientName.AccessibleDescription = "Patient Name";
			this.txtPatientName.AccessibleName = "Patient Name";
			this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientName.Location = new System.Drawing.Point(108, 4);
			this.txtPatientName.Name = "txtPatientName";
			this.txtPatientName.ReadOnly = true;
			this.txtPatientName.Size = new System.Drawing.Size(180, 20);
			this.txtPatientName.TabIndex = 14;
			this.txtPatientName.Text = "";
			// 
			// pageOrder
			// 
			this.pageOrder.Controls.Add(this.txtOrderStatus);
			this.pageOrder.Controls.Add(this.lblOrderStatus);
			this.pageOrder.Controls.Add(this.txtOrderDate);
			this.pageOrder.Controls.Add(this.lblOrderDate);
			this.pageOrder.Controls.Add(this.txtOrderedBy);
			this.pageOrder.Controls.Add(this.lblOrderedBy);
			this.pageOrder.Controls.Add(this.txtOrderComments);
			this.pageOrder.Controls.Add(this.lblOrderComments);
			this.pageOrder.Controls.Add(this.txtRequestedProcedure);
			this.pageOrder.Controls.Add(this.lblRequestedProcedure);
			this.pageOrder.Controls.Add(this.txtCPRSOrderNumber);
			this.pageOrder.Controls.Add(this.lblCPRSOrderNumber);
			this.pageOrder.Location = new System.Drawing.Point(4, 23);
			this.pageOrder.Name = "pageOrder";
			this.pageOrder.Size = new System.Drawing.Size(292, 213);
			this.pageOrder.TabIndex = 1;
			this.pageOrder.Text = "Order Details";
			this.pageOrder.Visible = false;
			// 
			// txtOrderStatus
			// 
			this.txtOrderStatus.AccessibleDescription = "Order Status";
			this.txtOrderStatus.AccessibleName = "Order Status";
			this.txtOrderStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderStatus.Location = new System.Drawing.Point(108, 158);
			this.txtOrderStatus.Name = "txtOrderStatus";
			this.txtOrderStatus.ReadOnly = true;
			this.txtOrderStatus.Size = new System.Drawing.Size(180, 20);
			this.txtOrderStatus.TabIndex = 25;
			this.txtOrderStatus.Text = "";
			// 
			// lblOrderStatus
			// 
			this.lblOrderStatus.Location = new System.Drawing.Point(5, 158);
			this.lblOrderStatus.Name = "lblOrderStatus";
			this.lblOrderStatus.Size = new System.Drawing.Size(104, 20);
			this.lblOrderStatus.TabIndex = 10;
			this.lblOrderStatus.Text = "Order Status";
			this.lblOrderStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOrderDate
			// 
			this.txtOrderDate.AccessibleDescription = "Order Date";
			this.txtOrderDate.AccessibleName = "Order Date";
			this.txtOrderDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderDate.Location = new System.Drawing.Point(108, 28);
			this.txtOrderDate.Name = "txtOrderDate";
			this.txtOrderDate.ReadOnly = true;
			this.txtOrderDate.Size = new System.Drawing.Size(180, 20);
			this.txtOrderDate.TabIndex = 21;
			this.txtOrderDate.Text = "";
			// 
			// lblOrderDate
			// 
			this.lblOrderDate.Location = new System.Drawing.Point(4, 28);
			this.lblOrderDate.Name = "lblOrderDate";
			this.lblOrderDate.Size = new System.Drawing.Size(104, 20);
			this.lblOrderDate.TabIndex = 2;
			this.lblOrderDate.Text = "Order Date";
			this.lblOrderDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOrderedBy
			// 
			this.txtOrderedBy.AccessibleDescription = "Ordering Physician";
			this.txtOrderedBy.AccessibleName = "Ordering Physician";
			this.txtOrderedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderedBy.Location = new System.Drawing.Point(108, 52);
			this.txtOrderedBy.Name = "txtOrderedBy";
			this.txtOrderedBy.ReadOnly = true;
			this.txtOrderedBy.Size = new System.Drawing.Size(180, 20);
			this.txtOrderedBy.TabIndex = 22;
			this.txtOrderedBy.Text = "";
			// 
			// lblOrderedBy
			// 
			this.lblOrderedBy.Location = new System.Drawing.Point(4, 52);
			this.lblOrderedBy.Name = "lblOrderedBy";
			this.lblOrderedBy.Size = new System.Drawing.Size(104, 20);
			this.lblOrderedBy.TabIndex = 4;
			this.lblOrderedBy.Text = "Ordering Physician";
			this.lblOrderedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOrderComments
			// 
			this.txtOrderComments.AccessibleDescription = "Order Comments";
			this.txtOrderComments.AccessibleName = "Order Comments";
			this.txtOrderComments.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOrderComments.Location = new System.Drawing.Point(108, 100);
			this.txtOrderComments.Multiline = true;
			this.txtOrderComments.Name = "txtOrderComments";
			this.txtOrderComments.ReadOnly = true;
			this.txtOrderComments.Size = new System.Drawing.Size(180, 52);
			this.txtOrderComments.TabIndex = 24;
			this.txtOrderComments.Text = "";
			// 
			// lblOrderComments
			// 
			this.lblOrderComments.Location = new System.Drawing.Point(4, 100);
			this.lblOrderComments.Name = "lblOrderComments";
			this.lblOrderComments.Size = new System.Drawing.Size(104, 20);
			this.lblOrderComments.TabIndex = 8;
			this.lblOrderComments.Text = "Order Comments";
			this.lblOrderComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtRequestedProcedure
			// 
			this.txtRequestedProcedure.AccessibleDescription = "Associated Test";
			this.txtRequestedProcedure.AccessibleName = "Associated Test";
			this.txtRequestedProcedure.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRequestedProcedure.Location = new System.Drawing.Point(108, 76);
			this.txtRequestedProcedure.Name = "txtRequestedProcedure";
			this.txtRequestedProcedure.ReadOnly = true;
			this.txtRequestedProcedure.Size = new System.Drawing.Size(180, 20);
			this.txtRequestedProcedure.TabIndex = 23;
			this.txtRequestedProcedure.Text = "";
			// 
			// lblRequestedProcedure
			// 
			this.lblRequestedProcedure.Location = new System.Drawing.Point(4, 76);
			this.lblRequestedProcedure.Name = "lblRequestedProcedure";
			this.lblRequestedProcedure.Size = new System.Drawing.Size(104, 20);
			this.lblRequestedProcedure.TabIndex = 6;
			this.lblRequestedProcedure.Text = "Associated Test";
			this.lblRequestedProcedure.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtCPRSOrderNumber
			// 
			this.txtCPRSOrderNumber.AccessibleDescription = "C P R S Order Number";
			this.txtCPRSOrderNumber.AccessibleName = "C P R S Order Number";
			this.txtCPRSOrderNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCPRSOrderNumber.Location = new System.Drawing.Point(108, 4);
			this.txtCPRSOrderNumber.Name = "txtCPRSOrderNumber";
			this.txtCPRSOrderNumber.ReadOnly = true;
			this.txtCPRSOrderNumber.Size = new System.Drawing.Size(180, 20);
			this.txtCPRSOrderNumber.TabIndex = 20;
			this.txtCPRSOrderNumber.Text = "";
			// 
			// lblCPRSOrderNumber
			// 
			this.lblCPRSOrderNumber.Location = new System.Drawing.Point(4, 4);
			this.lblCPRSOrderNumber.Name = "lblCPRSOrderNumber";
			this.lblCPRSOrderNumber.Size = new System.Drawing.Size(104, 20);
			this.lblCPRSOrderNumber.TabIndex = 0;
			this.lblCPRSOrderNumber.Text = "CPRS Order No.";
			this.lblCPRSOrderNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtCollectionDate
			// 
			this.txtCollectionDate.AccessibleDescription = "Collection Date";
			this.txtCollectionDate.AccessibleName = "Collection Date";
			this.txtCollectionDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCollectionDate.Location = new System.Drawing.Point(116, 68);
			this.txtCollectionDate.Name = "txtCollectionDate";
			this.txtCollectionDate.ReadOnly = true;
			this.txtCollectionDate.Size = new System.Drawing.Size(180, 20);
			this.txtCollectionDate.TabIndex = 10;
			this.txtCollectionDate.Text = "";
			// 
			// txtSpecimenNumber
			// 
			this.txtSpecimenNumber.AccessibleDescription = "Specimen U I D";
			this.txtSpecimenNumber.AccessibleName = "Specimen U I D";
			this.txtSpecimenNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenNumber.Location = new System.Drawing.Point(116, 20);
			this.txtSpecimenNumber.Name = "txtSpecimenNumber";
			this.txtSpecimenNumber.ReadOnly = true;
			this.txtSpecimenNumber.Size = new System.Drawing.Size(180, 20);
			this.txtSpecimenNumber.TabIndex = 8;
			this.txtSpecimenNumber.Text = "";
			// 
			// lblSpecimenNumber
			// 
			this.lblSpecimenNumber.Location = new System.Drawing.Point(8, 20);
			this.lblSpecimenNumber.Name = "lblSpecimenNumber";
			this.lblSpecimenNumber.Size = new System.Drawing.Size(120, 20);
			this.lblSpecimenNumber.TabIndex = 0;
			this.lblSpecimenNumber.Text = "Specimen UID";
			this.lblSpecimenNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 92);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(96, 20);
			this.lblExpirationDate.TabIndex = 6;
			this.lblExpirationDate.Text = "Expiration Date";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPhlebotomist
			// 
			this.lblPhlebotomist.Location = new System.Drawing.Point(8, 44);
			this.lblPhlebotomist.Name = "lblPhlebotomist";
			this.lblPhlebotomist.Size = new System.Drawing.Size(96, 20);
			this.lblPhlebotomist.TabIndex = 2;
			this.lblPhlebotomist.Text = "Phlebotomist";
			this.lblPhlebotomist.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPhlebotomist
			// 
			this.txtPhlebotomist.AccessibleDescription = "Phlebotomist";
			this.txtPhlebotomist.AccessibleName = "Phlebotomist";
			this.txtPhlebotomist.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPhlebotomist.Location = new System.Drawing.Point(116, 44);
			this.txtPhlebotomist.Name = "txtPhlebotomist";
			this.txtPhlebotomist.ReadOnly = true;
			this.txtPhlebotomist.Size = new System.Drawing.Size(180, 20);
			this.txtPhlebotomist.TabIndex = 9;
			this.txtPhlebotomist.Text = "";
			// 
			// lblCollectionDate
			// 
			this.lblCollectionDate.Location = new System.Drawing.Point(8, 68);
			this.lblCollectionDate.Name = "lblCollectionDate";
			this.lblCollectionDate.Size = new System.Drawing.Size(96, 20);
			this.lblCollectionDate.TabIndex = 4;
			this.lblCollectionDate.Text = "Collection Date";
			this.lblCollectionDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSearchResults
			// 
			this.grpSearchResults.AccessibleDescription = "Specimen Search Results";
			this.grpSearchResults.AccessibleName = "Specimen Search Results";
			this.grpSearchResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchResults.Controls.Add(this.cbShowExpiredUnacceptable);
			this.grpSearchResults.Controls.Add(this.lvSearchResults);
			this.grpSearchResults.Location = new System.Drawing.Point(56, 76);
			this.grpSearchResults.Name = "grpSearchResults";
			this.grpSearchResults.Size = new System.Drawing.Size(320, 324);
			this.grpSearchResults.TabIndex = 4;
			this.grpSearchResults.TabStop = false;
			this.grpSearchResults.Text = "Specimen Search Results";
			// 
			// cbShowExpiredUnacceptable
			// 
			this.cbShowExpiredUnacceptable.AccessibleDescription = "Show Unacceptable and Expired Specimens";
			this.cbShowExpiredUnacceptable.AccessibleName = "Show Unacceptable and Expired Specimens";
			this.cbShowExpiredUnacceptable.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbShowExpiredUnacceptable.Location = new System.Drawing.Point(8, 304);
			this.cbShowExpiredUnacceptable.Name = "cbShowExpiredUnacceptable";
			this.cbShowExpiredUnacceptable.Size = new System.Drawing.Size(304, 16);
			this.cbShowExpiredUnacceptable.TabIndex = 6;
			this.cbShowExpiredUnacceptable.Text = "&Show Unacceptable and Expired Specimens";
			this.cbShowExpiredUnacceptable.CheckedChanged += new System.EventHandler(this.cbShowExpiredUnacceptable_CheckedChanged);
			// 
			// lvSearchResults
			// 
			this.lvSearchResults.AccessibleDescription = "Specimen Search Results";
			this.lvSearchResults.AccessibleName = "Specimen Search Results";
			this.lvSearchResults.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSearchResults.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.colVBECSSpecimen,
																							  this.colPatientName,
																							  this.colSSN,
																							  this.colAssociatedTest});
			this.lvSearchResults.FullRowSelect = true;
			this.lvSearchResults.HideSelection = false;
			this.lvSearchResults.Location = new System.Drawing.Point(5, 16);
			this.lvSearchResults.MultiSelect = false;
			this.lvSearchResults.Name = "lvSearchResults";
			this.lvSearchResults.Size = new System.Drawing.Size(304, 288);
			this.lvSearchResults.TabIndex = 5;
			this.lvSearchResults.View = System.Windows.Forms.View.Details;
			this.lvSearchResults.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSearchResults_ColumnClick);
			this.lvSearchResults.SelectedIndexChanged += new System.EventHandler(this.lvSearchResults_SelectedIndexChanged);
			// 
			// colVBECSSpecimen
			// 
			this.colVBECSSpecimen.Text = "Specimen UID";
			this.colVBECSSpecimen.Width = 80;
			// 
			// colPatientName
			// 
			this.colPatientName.Text = "Patient Name";
			this.colPatientName.Width = 100;
			// 
			// colSSN
			// 
			this.colSSN.Text = "Patient ID";
			this.colSSN.Width = 70;
			// 
			// colAssociatedTest
			// 
			this.colAssociatedTest.Text = "Test Name";
			this.colAssociatedTest.Width = 100;
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// PatientOrderSelector
			// 
			this.Controls.Add(this.grpSearchCriteria);
			this.Controls.Add(this.grpSelectedSpecimen);
			this.Controls.Add(this.grpSearchResults);
			this.Controls.Add(this.grpImage);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "PatientOrderSelector";
			this.Size = new System.Drawing.Size(688, 400);
			this.grpImage.ResumeLayout(false);
			this.grpSearchCriteria.ResumeLayout(false);
			this.grpSelectedSpecimen.ResumeLayout(false);
			this.tabPatientOrder.ResumeLayout(false);
			this.pagePatient.ResumeLayout(false);
			this.pageOrder.ResumeLayout(false);
			this.grpSearchResults.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Events/Event Handlers

		/// <summary>
		/// ItemSelected Event Handler
		/// </summary>
		protected virtual void OnItemSelected()
		{
			//
			this._specimen = new BOL.Specimen(this._patientSpecimenGUID);
			//
			if ((this._specimen != null) && (this._specimen.Patient != null))
			{
				this.patientInfoToolbar1.Patient = this._specimen.Patient;
			}
			//
			if(ItemSelected != null)
				ItemSelected(true, EventArgs.Empty);
		}

		/// <summary>
		/// ItemDeselected Event Handler
		/// </summary>
		protected virtual void OnItemDeselected()
		{
			//
			this._specimen = null;
			//
			if(ItemDeselected != null)
				ItemDeselected(false, EventArgs.Empty);
		}

		/// <summary>
		/// Event that handles the click on special instructions and transfusion requirements button
		/// </summary>
		public event EventHandler SIAndTRClick
		{
			add
			{
				onSIAndTRClick += value;
			}
			remove
			{
				onSIAndTRClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the blood availability button
		/// </summary>
		public event EventHandler BloodAvailClick
		{
			add
			{
				onBloodAvailClick += value;
			}
			remove
			{
				onBloodAvailClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the display patient VBECS data
		/// </summary>
		public event EventHandler VbecsInfoClick
		{
			add
			{
				onVbecsInfoClick += value;
			}
			remove
			{
				onVbecsInfoClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the patient medications button
		/// </summary>
		public event EventHandler MedicationsClick
		{
			add
			{
				onMedicationsClick += value;
			}
			remove
			{
				onMedicationsClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the transfusion history button
		/// </summary>
		public event EventHandler TransHistoryClick
		{
			add
			{
				onTransHistoryClick += value;
			}
			remove
			{
				onTransHistoryClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the patient clinical data button
		/// </summary>
		public event EventHandler ClinicalInfoClick
		{
			add
			{
				onClinicalInfoClick += value;
			}
			remove
			{
				onClinicalInfoClick -= value;
			}
		}

		/// <summary>
		/// Calls the event when special instructions and patient transfusion requirements button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSpecialInstructions_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onSIAndTRClick != null)
			{
				onSIAndTRClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when blood availability button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnBloodAvailability_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onBloodAvailClick != null)
			{
				onBloodAvailClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient VBECS data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPatientInfo_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onVbecsInfoClick != null)
			{
				onVbecsInfoClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient current medications button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCurrentMeds_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onMedicationsClick != null)
			{
				onMedicationsClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient transfusion history button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnTransfusionHistory_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onTransHistoryClick != null)
			{
				onTransHistoryClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient clinical data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClinicalData_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onClinicalInfoClick != null)
			{
				onClinicalInfoClick(sender,e);
			}
		}

		/// <summary>
		/// Handles click on the search button. Finds specimens that match the search criteria
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			string patientName = string.Empty;
			string patientSSN = string.Empty;

			using (new WaitCursor())
			{
				try
				{
					this.ParsePatientSearchString(this.txtSearchNameSSN.Text,out patientName,out patientSSN);

					_dtSpecimenSearchDetails = BOL.Specimen.GetSpecimenSearchDetails(this.txtSearchOrderNumber.Text.ToUpper(), 
												patientSSN, patientName);
					if(this._unexpiredOnlySpecimen == true)
					{
						this.FilterExpiredSpecimen();
					}
					else
					{
						PopulateForm();
					}
				}
				catch (BOL.NoRecordsFoundException)
				{
					this.Clear();
					this.lvSearchResults.Columns[0].Width = this._noRecordsFoundColSize;
					ListViewItem lvi = new ListViewItem(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
					this.lvSearchResults.Items.Add(lvi);
					controls.VbecsFunction.SetColumnWidths(this.lvSearchResults);
				}
			}
		}

		/// <summary>
		/// Handles activation of the item on the list. Fills information about specimen, patient and orders
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>

		private void lvSearchResults_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.OnUserActivity();

				if (lvSearchResults.SelectedItems.Count > 0 && lvSearchResults.SelectedItems[0].Tag != null)
				{
					//Get selected specimen/patient/order details 
					ListViewItem lvItem = lvSearchResults.SelectedItems[0];
					DataRow drSpecimenSearchDetails = (DataRow) lvItem.Tag;
					BOL.Patient patient = new BOL.Patient(drSpecimenSearchDetails);
				
					//Specimen
					this.txtSpecimenNumber.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenUid) ? string.Empty : drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenUid].ToString();
					//this.txtExpirationDate.Text = drSpecimenSearchDetails.IsNull(TABLE.ExceptionExpiredUnitReceived.ExpirationDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.ExceptionExpiredUnitReceived.ExpirationDate]);
					this.txtExpirationDate.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenExpirationDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenExpirationDate]);
					this.txtPhlebotomist.Text = drSpecimenSearchDetails.IsNull(ARTIFICIAL.Phlebotomist) ? string.Empty : drSpecimenSearchDetails[ARTIFICIAL.Phlebotomist].ToString();
					this.txtCollectionDate.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenCollectionDate) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenCollectionDate]);
					if ((bool)drSpecimenSearchDetails[TABLE.PatientSpecimen.UnacceptableSpecimenIndicator])
					{
						this.txtVisualInspection.Text = "Unacceptable";
					}
					else
					{
						this.txtVisualInspection.Text = "Acceptable";
					}
					//Patient
					this.txtPatientName.Text = lvItem.SubItems[1].Text;
					this.txtSSN.Text = drSpecimenSearchDetails[TABLE.Patient.DisplayVistaPatientId].ToString();//lvItem.SubItems[2].Text;
					char sex = drSpecimenSearchDetails.IsNull(TABLE.Patient.PatientSexCode) ? char.MinValue : Convert.ToChar(drSpecimenSearchDetails[TABLE.Patient.PatientSexCode]);
					this.txtSex.Text = Common.Utility.GetSexEnumFromSexChar(sex).ToString();
					this.txtDOB.Text = drSpecimenSearchDetails.IsNull(TABLE.Patient.PatientDob) ? string.Empty : Common.VBECSDateTime.FormatDateString(drSpecimenSearchDetails[TABLE.Patient.PatientDob]);
					this.txtABORh.Text = patient.AboRh.AboRHText;
					this.picJustified.Visible = (patient.JustifiedAboRH);
					
					//Order
					this.txtOrderedBy.Text = BOL.Patient.BuildDisplayName(drSpecimenSearchDetails[TABLE.PatientOrder.OrderingProviderFirstName].ToString(), 
											drSpecimenSearchDetails[TABLE.PatientOrder.OrderingProviderMiddleInitial].ToString(), 
											drSpecimenSearchDetails[TABLE.PatientOrder.OrderingProviderLastName].ToString());
					this.txtOrderComments.Text = drSpecimenSearchDetails.IsNull(ARTIFICIAL.ComponentTestComment) ? string.Empty : drSpecimenSearchDetails[ARTIFICIAL.ComponentTestComment].ToString();
					this.txtCPRSOrderNumber.Text = drSpecimenSearchDetails.IsNull(TABLE.OrderedTest.CprsOrderNumber) ? string.Empty : drSpecimenSearchDetails[TABLE.OrderedTest.CprsOrderNumber].ToString();
					this.txtOrderDate.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientOrder.OrderPlacedDatetime) ? string.Empty : Common.VBECSDateTime.FormatDateTimeString(drSpecimenSearchDetails[TABLE.PatientOrder.OrderPlacedDatetime]);
					this.txtRequestedProcedure.Text = drSpecimenSearchDetails.IsNull(ARTIFICIAL.ComponentTestName) ? string.Empty : drSpecimenSearchDetails[ARTIFICIAL.ComponentTestName].ToString();	
					this.txtOrderStatus.Text = drSpecimenSearchDetails.IsNull(TABLE.OrderStatus.OrderStatusText) ? string.Empty : drSpecimenSearchDetails[TABLE.OrderStatus.OrderStatusText].ToString();

					//Set PatientSpecimenGuid (property)
					this._patientSpecimenGUID = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.PatientSpecimenGuid) ? Guid.Empty : (Guid) drSpecimenSearchDetails[TABLE.PatientSpecimen.PatientSpecimenGuid];
					//Set PatientOrderGuid (property)
					this._patientOrderGUID = drSpecimenSearchDetails.IsNull(TABLE.PatientOrder.PatientOrderGuid) ? Guid.Empty : (Guid) drSpecimenSearchDetails[TABLE.PatientOrder.PatientOrderGuid];

					//There properties are needed for UC 45
					//If it's a Component Order only XM test can be ordered
					if(drSpecimenSearchDetails.IsNull(TABLE.OrderableTest.OrderableTestId))
					{
						this._orderedComponentGuid = drSpecimenSearchDetails.IsNull(ARTIFICIAL.ComponentTestGuid) ? Guid.Empty : (Guid) drSpecimenSearchDetails[ARTIFICIAL.ComponentTestGuid];
						this._orderableTestID = (int) Common.OrderableTest.XM;
                        //CR 3421
                        this._orderedTestGuid = Guid.Empty;
                    }
					else
					{
						this._orderedTestGuid = drSpecimenSearchDetails.IsNull(ARTIFICIAL.ComponentTestGuid) ? Guid.Empty : (Guid) drSpecimenSearchDetails[ARTIFICIAL.ComponentTestGuid];
						this._orderableTestID = (int) drSpecimenSearchDetails[TABLE.OrderableTest.OrderableTestId];
                        //CR 3421
                        this._orderedComponentGuid = Guid.Empty;
                    }
					this._patientTreatmentGuid = drSpecimenSearchDetails.IsNull(TABLE.PatientTreatment.PatientTreatmentGuid) ? Guid.Empty : (Guid) drSpecimenSearchDetails[TABLE.PatientTreatment.PatientTreatmentGuid];
					this._orderStatusCode = drSpecimenSearchDetails.IsNull(TABLE.OrderStatus.OrderStatusCode) ? Common.OrderStatus.Unknown : Common.Utility.GetOrderStatusCodeFromString(drSpecimenSearchDetails[TABLE.OrderStatus.OrderStatusCode].ToString());
					this.OnItemSelected();
					
					//Set tooltip on ABORh 
					if (this.txtABORh.Text.ToString() != String.Empty)
					{
						this.toolTip1.SetToolTip(this.txtABORh,this._specimen.Patient.GetPatientHistoricABORhForTooltip());
					}
				}
				else
				{
					this.OnItemDeselected();
				}
			}
			catch (Exception err)
			{
				MessageBox.Show(err.Message,"VBECS - Error",MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
			}
		}

		/// <summary>
		/// Handles the changes in the search criteria
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SearchCriteriaChanged(object sender, System.EventArgs e)
		{
			if (this._nameEx.IsMatch(this.txtSearchNameSSN.Text.ToUpper()) ||
				this._lastfiveEx.IsMatch(this.txtSearchNameSSN.Text.ToUpper()) ||
				this._ssnEx.IsMatch(this.txtSearchNameSSN.Text.ToUpper()) ||
				this.txtSearchOrderNumber.Text != String.Empty)
			{
				this.btnSearch.EnabledButton = true;
			}
			else
			{
				this.btnSearch.EnabledButton = false;
			}
		}

		private void btnSearch_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnSearch.EnabledButton == false)
			{
				this.toolTip1.SetToolTip(this.btnSearch, Common.StrRes.Tooltips.Common.PatientSpecimenSearch().ResString);
			}
		}

		private void lvSearchResults_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			this.OnUserActivity();
			
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, controls.ColumnClickSorter.ColumnSortType.String);
		}

		#endregion

		#region Properties

		/// <summary>
		/// Get\Set the value of Specimen
		/// </summary>
		public BOL.Specimen Specimen
		{
			get
			{
				return this._specimen;
			}
			set
			{
				this._specimen = value;
			}
		}

		/// <summary>
		/// Get the value of PatientSpecimenGuid
		/// </summary>
		public Guid PatientSpecimenGuid
		{
			get
			{
				return _patientSpecimenGUID;
			}
		}

		/// <summary>
		/// Get and set the value of PatientOrderGuid
		/// </summary>
		public Guid PatientOrderGuid
		{
			set
			{
				this._patientOrderGUID = value;
			}
			
			get
			{
				return _patientOrderGUID;
			}
		}
		/// <summary>
		/// Get and set the value of OrderedTestGuid
		/// </summary>
		public Guid OrderedTestGuid
		{
			set
			{
				this._orderedTestGuid = value;
			}
			
			get
			{
				return _orderedTestGuid;
			}
		}

		/// <summary>
		/// Get and set the value of OrderedComponentGuid
		/// </summary>
		public Guid OrderedComponentGuid
		{
			set
			{
				this._orderedComponentGuid = value;
			}
			
			get
			{
				return _orderedComponentGuid;
			}
		}

		/// <summary>
		/// Get and set the value of PatientTreatmentGuid
		/// </summary>
		public Guid PatientTreatmentGuid
		{
			set
			{
				this._patientTreatmentGuid = value;
			}
			
			get
			{
				return _patientTreatmentGuid;
			}
		}

		/// <summary>
		/// Get and set the value of OrderableTestId
		/// </summary>
		public int OrderableTestId
		{
			set
			{
				this._orderableTestID= value;
			}
			
			get
			{
				return _orderableTestID;
			}
		}

		/// <summary>
		///OrderStatusCode
		/// </summary>
		public Common.OrderStatus OrderStatusCode
		{
			get
			{
				return this._orderStatusCode;
			}

			set
			{
				this._orderStatusCode = value;
			}
		}

		/// <summary>
		/// Get and set the value of UnexpiredOnlySpecimen
		/// </summary>
		public bool UnexpiredOnlySpecimen
		{
			set
			{
				this._unexpiredOnlySpecimen = value;
			}
			
			get
			{
				return _unexpiredOnlySpecimen;
			}
		}

		/// <summary>
		/// Get the value of SpecimenUid
		/// </summary>
		public string SpecimenUid
		{
			get
			{
				return this.txtSpecimenNumber.Text;
			}
		}

		/// <summary>
		/// Indicates whether the SI (and) TR button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the SI & TR button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledSIAndTRButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledSIAndTRButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledSIAndTRButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the blood availability button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the blood availability button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledBloodAvailButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledBloodAvailButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledBloodAvailButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Orders button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Orders button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentOrdersButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledRecentOrdersButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledRecentOrdersButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Medication Profile button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Medication Profile button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledMedicationButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledMedicationButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledMedicationButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Transfusions/Issues button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Transfusions/Issues button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentTransfusionsIssuesButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Transfusion Reaction History button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Transfusion Reaction History button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledTransfusionReactionHistoryButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = value;
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// Clear the data on the form
		/// </summary>
		private void Clear()
		{
			//Clear search items
			this.lvSearchResults.Items.Clear();

			//Specimen
			this.txtSpecimenNumber.Text = string.Empty;
			this.txtExpirationDate.Text = string.Empty;
			this.txtPhlebotomist.Text = string.Empty;
			this.txtCollectionDate.Text = string.Empty;

			//Patient
			this.txtPatientName.Text = string.Empty;
			this.txtSSN.Text = string.Empty;
			this.txtSex.Text = string.Empty;
			this.txtDOB.Text = string.Empty;
			this.txtABORh.Text = string.Empty;
			this.picJustified.Visible = false;
			
			//Order
			this.txtOrderedBy.Text = string.Empty;
			this.txtOrderComments.Text = string.Empty;
			this.txtCPRSOrderNumber.Text = string.Empty;
			this.txtOrderDate.Text = string.Empty;
			this.txtRequestedProcedure.Text = string.Empty;

			//Fire deselected item event
			this.OnItemDeselected();
		}

		/// <summary>
		/// Populates the list of specimens
		/// </summary>
		private void PopulateForm()
		{
			this.lvSearchResults.Items.Clear();

                //CR3058 - there was a giant try/catch that absorbed all exceptions for this for-block, and it was removed
				foreach ( DataRow drSpecimenSearchDetails in _dtSpecimenSearchDetails.Rows)
				{
					if ((this._patient != null) && (this._patient.PatientGuid != (Guid)drSpecimenSearchDetails[TABLE.Patient.PatientGuid]))
					{
						continue;
					}
					//List view
					ListViewItem lvItem = new ListViewItem();
					lvItem.Text = drSpecimenSearchDetails.IsNull(TABLE.PatientSpecimen.SpecimenUid) ? string.Empty : (string) drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenUid];			

					lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drSpecimenSearchDetails[TABLE.Patient.PatientFirstName].ToString(), 
						drSpecimenSearchDetails[TABLE.Patient.PatientMiddleName].ToString(), 
						drSpecimenSearchDetails[TABLE.Patient.PatientLastName].ToString()));
					lvItem.SubItems.Add(drSpecimenSearchDetails[TABLE.Patient.DisplayVistaPatientId].ToString());
					lvItem.SubItems.Add(drSpecimenSearchDetails.IsNull(ARTIFICIAL.ComponentTestName) ? string.Empty : drSpecimenSearchDetails[ARTIFICIAL.ComponentTestName].ToString());
					lvItem.Tag = drSpecimenSearchDetails;
					if ((System.Convert.ToDateTime(drSpecimenSearchDetails[TABLE.PatientSpecimen.SpecimenExpirationDate])< BOL.VBECSDateTime.GetDivisionCurrentDateTime()) ||
						((bool)drSpecimenSearchDetails[TABLE.PatientSpecimen.UnacceptableSpecimenIndicator]))
					{
						lvItem.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
					}
					this.lvSearchResults.Items.Add(lvItem);
				}
				// Only default selection if one match, else user must choose
				if ( lvSearchResults.Items.Count == 1 )
				{
					lvSearchResults.Items[0].Selected = true;
				}
				else
				{
					lvSearchResults.SelectedItems.Clear();
				}
				//
				if (this.lvSearchResults.Items.Count == 0)
				{
					this.Clear();
					ListViewItem lvItem = new ListViewItem(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
					this.lvSearchResults.Items.Add(lvItem);
					lvItem.Tag = null;
				}
			
				controls.VbecsFunction.SetColumnWidths(this.lvSearchResults);

		}

		/// <summary> 
		/// Filter expired and unacceptable specimens.  
		/// </summary>
		private void FilterExpiredSpecimen()
		{
			//BR_35.21
			//Set filter criteria and sort column and direction
			string filterCriteria = TABLE.PatientSpecimen.SpecimenExpirationDate+" >= #" +  BOL.VBECSDateTime.GetDivisionCurrentDateTime() + "# AND "+TABLE.PatientSpecimen.UnacceptableSpecimenIndicator+" = 0";
			string sortValue = TABLE.PatientSpecimen.SpecimenExpirationDate+Utility.DescSortOrderSuffix;

			//Apply filter criteria to the table 
			DataRow[] filteredSpecimenRows = this._dtSpecimenSearchDetails.Select(filterCriteria, sortValue);

			this.lvSearchResults.Items.Clear();

                //CR3058 - there was a giant try/catch that absorbed all exceptions for this for-block, and it was removed
				foreach (DataRow drFilteredSpecimen in filteredSpecimenRows)
				{
					if ((this._patient != null) && (this._patient.PatientGuid != (Guid)drFilteredSpecimen[TABLE.Patient.PatientGuid]))
					{
						continue;
					}
					//List view
					ListViewItem lvItem = new ListViewItem();
					lvItem.Text = drFilteredSpecimen.IsNull(TABLE.PatientSpecimen.SpecimenUid) ? string.Empty : (string) drFilteredSpecimen[TABLE.PatientSpecimen.SpecimenUid];			

					lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(drFilteredSpecimen[TABLE.Patient.PatientFirstName].ToString(), 
						drFilteredSpecimen[TABLE.Patient.PatientMiddleName].ToString(), 
						drFilteredSpecimen[TABLE.Patient.PatientLastName].ToString()));
					lvItem.SubItems.Add(drFilteredSpecimen[TABLE.Patient.DisplayVistaPatientId].ToString()); 
					lvItem.SubItems.Add(drFilteredSpecimen.IsNull(ARTIFICIAL.ComponentTestName) ? string.Empty : drFilteredSpecimen[ARTIFICIAL.ComponentTestName].ToString());
					lvItem.Tag = drFilteredSpecimen;
					this.lvSearchResults.Items.Add(lvItem);
				}
				// Only default selection if one match, else user must choose
				if ( lvSearchResults.Items.Count == 1 )
				{
					lvSearchResults.Items[0].Selected = true;
				}
				else
				{
					lvSearchResults.SelectedItems.Clear();
				}
				//
				if (this.lvSearchResults.Items.Count == 0)
				{
					this.Clear();
					ListViewItem lvItem = new ListViewItem(Common.StrRes.InfoMsg.UC020.NoMatchingEntries().ResString);
					this.lvSearchResults.Items.Add(lvItem);
					lvItem.Tag = null;
				}

				controls.VbecsFunction.SetColumnWidths(this.lvSearchResults);

		}
	
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>08/05/2002</CreationDate>
		///
		/// <summary>
		/// Private method to parse the entered search string to determine if Patinet Name or ssn or last Name 
		/// initial and last 4 digit of SSN.  Name and SSN are returned as out parameters.
		/// Reused code from PatientSelectTool.cs
		/// </summary>
		/// <param name="searchString"></param>
		/// <param name="patientName"></param>
		/// <param name="patientSSN"></param>
		private void ParsePatientSearchString(string searchString, out string patientName, out string patientSSN)
		{
			//Need to parse search string to determine if search is intended
			//to be on Name, full SSN, Last 5.
			//
			searchString = searchString.ToUpper();
			patientName = string.Empty;
			patientSSN = string.Empty;

			//Check for Last 5
			if (_lastfiveEx.IsMatch(searchString))
			{
				patientName = searchString.Substring(0,1);
				patientSSN = searchString.Substring(1,4);
				return;
			}
			//Check for SSN
			if (_ssnEx.IsMatch(searchString))
			{
				patientSSN = searchString;
				return;
			}
			//Check for Name
			if (_nameEx.IsMatch(searchString))
			{
				patientName = searchString;
				return;
			}
		}

		private void SetComponentProperties()
		{
			this.btnSearch.Text = "&Search";
			this.btnSearch.EnabledButton = false;
		}
		
		/// <summary>
		/// Sets a tooltip on ABORh textbox
		/// </summary>
		/// <param name="aboRHText"></param>
		public void SetAboRHToolTip(string aboRHText)
		{
			this.toolTip1.SetToolTip(this.txtABORh,aboRHText);
		}

	#endregion

		private void cbShowExpiredUnacceptable_CheckedChanged(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			this._unexpiredOnlySpecimen = !this.cbShowExpiredUnacceptable.Checked;
			//
			if (btnSearch.EnabledButton)
			{
				this.btnSearch_Click(sender,e);
			}
		}
		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessagesFor508()
		{
			string textToSpeak = string.Empty;
			if(this.picJustified.Visible)
			{
				textToSpeak = "The patient has a history of  justified ABO/Rh change";
			}
			return textToSpeak;
		}
	


	}
}